# -*- coding: utf-8 -*-
"""
Created on Tue Jun 7 16:45:48 2022

@author: thomas
Allgemeines Y-Y-Dreiphasensystem - mit Neutralleiter

"""

# Einbindung der erforderlichen Bibliotheken
import numpy as np
import cmath
import math

# Definition der Phasenspannungen
Uan = cmath.rect(230, math.radians(0))
Ubn = cmath.rect(230, math.radians(120))
Ucn = cmath.rect(230, math.radians(-120))

# Definition der Last
ZA = 12 + 17j
ZB = 10 +  8j
ZC =  6 - 12j

# Berechnung der Außenleiterströme
Ia = Uan/ZA
Ib = Ubn/ZB
Ic = Ucn/ZC

Betrag_Ia = np.round(abs(Ia), decimals=2)
Betrag_Ib = np.round(abs(Ib), decimals=2)
Betrag_Ic = np.round(abs(Ic), decimals=2)

Phase_Ia = np.round(math.degrees(cmath.phase(Ia)), decimals=2)
Phase_Ib = np.round(math.degrees(cmath.phase(Ib)), decimals=2)
Phase_Ic = np.round(math.degrees(cmath.phase(Ic)), decimals=2)

print("Außenleiterstrom Ia: Betrag:", Betrag_Ia,"A, Phase:", Phase_Ia)
print("Außenleiterstrom Ib: Betrag:", Betrag_Ib,"A, Phase:", Phase_Ib)
print("Außenleiterstrom Ic: Betrag:", Betrag_Ic,"A, Phase:", Phase_Ic)

# Berechnung des Stroms im neutralen Leiter
In = -(Ia + Ib + Ic)
Betrag_In = np.round(abs(In), decimals=2)
Phase_In = np.round(math.degrees(cmath.phase(In)), decimals=2)

print("Neutralleiterstrom In: Betrag:", Betrag_In,"A, Phase:", Phase_In)

