# -*- coding: utf-8 -*-
"""
Created on Tue Jun 7 10:42:27 2022

@author: thomas
Allgemeines Y-Y-Dreiphasensystem - kein Neutralleiter

"""

# Einbindung der erforderlichen Bibliotheken
import numpy as np
import numpy.linalg
import cmath
import math

# Definition der Phasenspannungen
Uan = cmath.rect(120, math.radians(0))
Ubn = cmath.rect(120, math.radians(-120))
Ucn = cmath.rect(120, math.radians(120))

# Definition der Last
ZA = 2 + 5j
ZB = 8 + 3j
ZC = -7j

# Berechnen der Außenleiterströme
Z = np.array([[ZA + ZB, -ZB],
              [-ZB, ZB + ZC]])
U = np.array([-Ubn + Uan, -Ucn + Ubn])
I = np.linalg.solve(Z, U)

# Umrechnen der Maschenströme in die Außenleiterströme
Betrag_Ia = np.round(abs(I[0]),        decimals=2)
Betrag_Ib = np.round(abs(I[1] - I[0]), decimals=2)
Betrag_Ic = np.round(abs(-I[1]),       decimals=2)

Phase_Ia = np.round(math.degrees(cmath.phase(I[0])),        decimals=2)
Phase_Ib = np.round(math.degrees(cmath.phase(I[1] - I[0])), decimals=2)
Phase_Ic = np.round(math.degrees(cmath.phase(-I[1])),       decimals=2)

print("Außenleiterstrom Ia: Betrag:", Betrag_Ia,"A, Phase:", Phase_Ia)
print("Außenleiterstrom Ib: Betrag:", Betrag_Ib,"A, Phase:", Phase_Ib)
print("Außenleiterstrom Ic: Betrag:", Betrag_Ic,"A, Phase:", Phase_Ic)

# Berechnen der komplexen Leistung
SA = np.round((np.square(Betrag_Ia) * ZA), decimals=0)
SB = np.round((np.square(Betrag_Ib) * ZB), decimals=0)
SC = np.round((np.square(Betrag_Ic) * ZC), decimals=0)

print()
print("Leistung in Phase A:", SA,"VA")
print("Leistung in Phase B:", SB,"VA")
print("Leistung in Phase C:", SC,"VA")

print("Gesamtleistung:", SA + SB + SC,"VA")
